import collections

DiffResult = collections.namedtuple('DiffResult', ['insert', 'remove'])


def diff(current, target):
    to_remove = {key for key in current if key not in target}
    to_insert = {}
    for key, value in target.iteritems():
        if key not in current:
            to_insert[key] = value
        elif current[key] != value:
            to_remove.add(key)
            to_insert[key] = value

    return DiffResult(insert=to_insert, remove=to_remove)
