# Функциональное тестирование деплоера

## Blackbox
Запускаем деплоер, задаём спеку, проверяем наблюдаемый на файловой системе результат.
Спека задаётся не через YT, а через локальный файл, таким образом работа непосредственно с YT не проверяется.
Аналогично, статус записывается в локальный файл.

## Notifications
Для тестирования уведомлений используется специальный `workload`, обученный отвечать на уведомительные http-запросы.

## Chaos monkey
В деплоере реализована логика эмуляции случайных отказов: обращения к внешним системам
(получить target, выполнить уведомление, скачать ресурс) с заданной вероятностью завершаются исключением.
Режим включен в тестах с помощью переменной окружения `CHAOS_FAILURE_PROBABILITY` (см. `ya.make`).

## Запуск
Тесты помечены как `LARGE/fat`. В аркануме запускаются вручную. При локальном запуске рекомендуется
использовать опции `--keep-temps` и `--test-keep-symlinks`.
Без них система тестирования разломает `storage_root/tree`, так как эта папка целиком состоит из симлинков.
С симлинками у системы тестирования особые отношения:
она считает все симлинки своими и зачищает их по завершении тестов.
Подробности в [документации по системе тестирования](https://wiki.yandex-team.ru/yatool/test/).
Для пущего удобства, чтоб было сразу видно, где находятся логи и `storage_dir`-ы разных тестов,
рекомендуется строка запуска `ya make -AP --test-keep-symlinks --keep-temps`.
