import os
import logging

import shutil


def remove_dir(path):
    if os.path.exists(path):
        shutil.rmtree(path)
        _log.debug('removed dirs %s', path)


def ensure_dir(path):
    if not os.path.exists(path):
        os.makedirs(path)
        _log.debug('made dirs %s', path)


def set_symlink(source, link_name, overwrite=False):
    if os.path.islink(link_name) and os.readlink(link_name) == source:
        return
    if os.path.islink(link_name):
        if overwrite:
            os.unlink(link_name)
        else:
            raise RuntimeError('cannot overwrite existing link')
    os.symlink(source, link_name)


def unset_symlink(link):
    if os.path.islink(link):
        os.unlink(link)


_log = logging.getLogger(__name__)
