import pytest

import infra.callisto.deploy.storage.flat_storage as flat_storage


def test_all():
    res_name = 'abc'
    description = 'this is description'
    content = 'content'
    storage = flat_storage.FlatStorage('./test_all')

    assert not storage.list()
    assert not storage.exists('abc')
    assert not storage.is_fetched('abc')

    with storage.add(res_name, description) as path_to_file:
        with open(path_to_file, 'w') as f:
            f.write(content)

    assert storage.list()
    assert storage.exists(res_name)
    assert storage.is_fetched(res_name)
    assert storage.description(res_name) == description
    with open(storage.path_to_resource(res_name)) as f:
        assert f.read() == content

    with pytest.raises(AssertionError):
        storage.add(res_name, 'fake description')
    assert storage.description(res_name) == description

    storage.remove(res_name)
    assert not storage.list()
    assert not storage.exists('abc')
    assert not storage.is_fetched('abc')


def test_failed_add():
    res_name = 'abc'
    description = 'this is description'
    storage = flat_storage.FlatStorage('./test_failed_add')

    assert not storage.list()
    try:
        with storage.add(res_name, description) as path_to_file:
            with open(path_to_file, 'w'):
                raise RuntimeError()
    except RuntimeError:
        pass

    assert res_name in storage.list(), 'should be in list'
    assert storage.exists(res_name), 'should exist'
    assert not storage.is_fetched(res_name), 'but should be not ready'
    with pytest.raises(AssertionError):
        storage.description(res_name)

    storage.remove(res_name)
    with storage.add(res_name, description) as path_to_file:
        with open(path_to_file, 'w') as f:
            f.write('123')

    assert storage.exists(res_name)
    assert storage.is_fetched(res_name)
    assert storage.description(res_name) == description
