import os

import infra.callisto.deploy.storage.tree_storage as tree_storage
import infra.callisto.deploy.resource as deploy_resource


def test_all():
    root_path = './'
    storage = tree_storage.LinksTree(root_path)
    resource = deploy_resource.Resource('/test/namespace/', 'test/name')

    assert not os.path.lexists(tree_storage.resource_path(root_path, resource))
    storage.set_link(resource, '/what/ever/path/to/not-existing-resource/i/suppose')
    assert os.path.lexists(tree_storage.resource_path(root_path, resource))
    storage.unset_link(resource)
    assert not os.path.lexists(tree_storage.resource_path(root_path, resource))


def test_flap():
    root = '/the/root/'
    assert tree_storage.namespace_path(root, '/test/namespace/') == '/the/root/test/namespace/@resources'

    resource = deploy_resource.Resource('/test/namespace/', 'test/name')
    assert tree_storage.resource_path(root, resource) == '/the/root/test/namespace/@resources/test/name/@resource'
