"""this module ignores symlinks"""

from __future__ import absolute_import

import os
import logging
import collections

import infra.callisto.libraries.copier as copier

from . import inspect


SharedDir = collections.namedtuple('Resource', ['path', 'rbtorrent', 'size'])


def _dir_to_size_mapping(dir_spec):
    result = {dir_spec.path: dir_spec.size}
    for dir_ in dir_spec.dirs:
        result[dir_.path] = dir_.size
        result.update(_dir_to_size_mapping(dir_))
    return result


def share_recursive(root_path, max_depth=5, exclude=None, include=None):
    root_path = os.path.abspath(root_path)
    dir_to_size = _dir_to_size_mapping(inspect.inspect_directory(root_path))
    rbtorrent_before = copier.sky_share(root_path, exclude, include)

    result = []
    for sub_dir_path in _walk_dirs(root_path, max_depth=max_depth):
        rel_path = inspect.relative_path(root_path, sub_dir_path)
        rbtorrent = copier.sky_share(sub_dir_path, exclude, include)
        result.append(SharedDir(rel_path, rbtorrent, dir_to_size[rel_path]))
        logging.debug('shared %s', rel_path)

    rbtorrent_after = copier.sky_share(root_path, exclude, include)

    if rbtorrent_before != rbtorrent_after:
        raise RuntimeError('shard changed its content!. {} != {}'.format(rbtorrent_before, rbtorrent_after))
    return result


def _walk_dirs(directory, max_depth=10):
    result = []
    if max_depth > 0:
        for sub_dir_full_path in inspect.list_dir(directory, dirs=True, files=False):
            result += _walk_dirs(sub_dir_full_path, max_depth - 1)
    return result + [directory]
