import os

import infra.callisto.deploy.tracker.client.share as share
import infra.callisto.libraries.copier as copier


def test_share():
    copier.sky_share = _mock_sky_share

    test_path = os.path.join(os.getcwd(), 'test_share')
    os.makedirs(test_path)
    path_to_a = os.path.join(test_path, 'a')
    os.makedirs(path_to_a)

    with open(os.path.join(path_to_a, 'x'), 'w') as f:
        f.write('x' * 256)

    # make sure it works somehow
    share.share_recursive(test_path)


def _mock_sky_share(*args, **kwargs):
    return 'rbtorrent:fake'
