

class NoResourcesLeft(RuntimeError):
    pass


class _ResourceWrapper(object):
    def __init__(self, pool, resource):
        self.__pool = pool
        self.__resource = resource

    def __enter__(self):
        return self.__resource

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.__pool.reset(self.__resource)


class Pool(object):
    def __init__(self, resources):
        self._free_resources = set(resources)
        self._used_resources = set()

    def get(self):
        if not self._free_resources:
            raise NoResourcesLeft('no free resources at the moment')
        else:
            resource = self._free_resources.pop()
            self._used_resources.add(resource)
            return _ResourceWrapper(self, resource)

    def reset(self, resource):
        self._used_resources.remove(resource)
        self._free_resources.add(resource)
