import infra.callisto.deploy.resource as deploy_resource


def possible_namespaces(resource_id):
    paths = resource_id.strip('/').split('/')
    paths = [p for p in paths if p]
    for i in xrange(len(paths) - 1, 0, -1):
        yield deploy_resource.normalize_namespace(
            deploy_resource.safe_join_path(*paths[:i])
        )


def separate_resource_id(full_path, namespace):
    namespace = deploy_resource.normalize_namespace(namespace)
    full_path = deploy_resource.normalize_namespace(full_path)
    assert full_path.startswith(namespace)
    return deploy_resource.normalize_resource_name(full_path.replace(namespace, ''))
