from __future__ import absolute_import
import json
import logging
import subprocess

import retry
import infra.callisto.libraries.process as process
import six


def sky_get(
        resource_url,
        dst_dir,
        check_policy=None,
        timeout=60000,
        max_dl_speed=None,
        max_ul_speed=None,
        copier_opts=None,
        hardlink=False,
        container_params=None,
        **kwargs  # to get no error when adding new arg
):
    if 'rbtorrent' not in resource_url:
        resource_url = 'rbtorrent:' + resource_url

    check_policy = check_policy or {}

    args = [
        'sky',
        'get',
        '--user',
        '--wait',
        '--timeout={}'.format(timeout),
    ]
    if max_dl_speed:
        args += ['--max-dl-speed={}'.format(max_dl_speed)]
    if max_ul_speed:
        args += ['--max-ul-speed={}'.format(max_ul_speed)]
    if copier_opts:
        args += ['--opts="{}"'.format(copier_opts)]
    if hardlink:
        args += ['--deduplicate=Hardlink']
    args += [
        '--dir={}'.format(dst_dir),
        resource_url,
    ]

    run_in_container = True  # Set to False for local debug runs.
    if run_in_container:
        args = ['portoctl', 'exec', 'self/skyget-{}'.format(resource_url.replace('rbtorrent:', '')),
                "command={}".format(' '.join(args))]
        if container_params:
            args += ["{}={}".format(key, value) for key, value in six.iteritems(container_params)]

    _log.info(' '.join(args))
    process.execute(args, raise_on_error=True)

    if check_policy.get('repeat_sky_get'):
        _log.info('repeat sky get')
        process.execute(args, raise_on_error=True)


@retry.retry(tries=120, delay=60)
def sky_share(src_dir, exclude=None, include=None):
    """this function ignores symlinks (find -type f)"""
    if exclude and include:
        raise RuntimeError('Not supported')
    if exclude:
        cmd = 'sky share --dir="{}" $(cd "{}"; find -type f ! -path \'{}\') || exit 1'.format(src_dir, src_dir, exclude)
    elif include:
        cmd = 'sky share --dir="{}" $(cd "{}"; find -type f -path \'{}\') || exit 1'.format(src_dir, src_dir, include)
    else:
        cmd = 'sky share --dir="{}" $(cd "{}"; find -type f) || exit 1'.format(src_dir, src_dir)
    _log.info('Call %s', str(cmd))

    p = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
    out, err = p.communicate()
    return_code = p.returncode

    if return_code != 0:
        raise RuntimeError('sky share {} failed'.format(src_dir))
    return out.strip()


def sky_files(rbtorrent):
    """Call sky files to get json with files list"""
    cmd = ['sky files --json --full {}'.format(rbtorrent)]
    _log.info('Call %s', str(cmd))

    p = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
    out, err = p.communicate()
    return_code = p.returncode

    if return_code != 0:
        raise RuntimeError('sky files failed: {}'.format(err.strip()))
    return json.loads(out)


_log = logging.getLogger('utils.copier')
