import os
import logging

import infra.callisto.libraries.yt as yt_utils

SPECS_STR = '_specs_'
LOCK_STR = '_lock_'


def _specs_path(base_path):
    return os.path.join(base_path, SPECS_STR)


def _lock_path(base_path):
    return os.path.join(base_path, LOCK_STR)


def _ensure_node(yt_client, path, type_):
    if not yt_client.exists(path):
        yt_client.create(type_, path, recursive=True)


def lock_path(proxy, path):
    assert SPECS_STR not in path.split('/')
    assert LOCK_STR not in path.split('/')
    yt_client = yt_utils.create_yt_client(proxy)
    _ensure_node(yt_client, path, 'map_node')
    _ensure_node(yt_client, _lock_path(path), 'document')
    _ensure_node(yt_client, _specs_path(path), 'document')
    return yt_utils.lock(yt_client, _lock_path(path))


def update_path_specs(proxy, path, **kwargs):
    yt_client = yt_utils.create_yt_client(proxy)
    with yt_client.Transaction(type='master') as transaction:
        for key, value in kwargs.items():
            yt_client.set_attribute(_specs_path(path), key, value)
    _log.debug('upd %s specs, transaction_id: %s, specs: %s', path, transaction.transaction_id, kwargs)


def list_paths(proxy, base_path):
    yt_client = yt_utils.create_yt_client(proxy)
    paths = yt_client.search(base_path, node_type='document')
    return [
        os.path.relpath(path, base_path).replace(SPECS_STR, '').strip('/')
        for path in paths if path.endswith(SPECS_STR)
    ]


_log = logging.getLogger(__name__)
