import os
import logging
import logging.handlers

import kernel.util.logging as skynet_logging


def ensure_dir(path):
    if not os.path.exists(path):
        os.makedirs(path)


def configure_logging(
        path_to_logs,
        debug,
        max_bytes=300 * 1024 ** 2,
        backup_count=10,
):
    ensure_dir(path_to_logs)

    debug_handler = logging.handlers.RotatingFileHandler(
        os.path.join(path_to_logs, 'debug.log'),
        maxBytes=max_bytes, backupCount=backup_count,
    )
    debug_handler.setLevel(logging.DEBUG)
    skynet_logging.initialize(handler=debug_handler)

    info_handler = logging.handlers.RotatingFileHandler(
        os.path.join(path_to_logs, 'info.log'),
        maxBytes=max_bytes, backupCount=backup_count,
    )
    info_handler.setLevel(logging.INFO)
    skynet_logging.initialize(handler=info_handler)

    if debug:
        console_handler = logging.StreamHandler()
        console_handler.setLevel(logging.DEBUG)
        skynet_logging.initialize(handler=console_handler)

    logging.getLogger('requests').setLevel(logging.CRITICAL)
    logging.getLogger('httpserver').setLevel(logging.CRITICAL)
    logging.getLogger('werkzeug').addHandler(debug_handler)
    logging.getLogger('werkzeug').setLevel(0)
