from __future__ import absolute_import
import os
import select
import logging
import subprocess

import gevent
import gevent.select


def execute(popenargs, raise_on_error=False, **kwargs):
    logger = logging.getLogger('subprocess')

    child = subprocess.Popen(
        popenargs, stdout=subprocess.PIPE, stderr=subprocess.PIPE,
        preexec_fn=os.setpgrp,
        **kwargs
    )
    logger.info('[%s] call "%s"', child.pid, popenargs)

    p = gevent.select.poll()
    p.register(child.stdout, select.POLLIN)
    p.register(child.stderr, select.POLLIN)

    try:
        events = p.poll()
        while True:
            for rfd, event in events:
                if event & select.POLLIN:
                    if rfd == child.stdout.fileno():
                        line = child.stdout.readline()
                        if line:
                            logger.debug('[%s] %s', child.pid, line[:-1])
                        else:
                            p.unregister(child.stdout)

                    elif rfd == child.stderr.fileno():
                        line = child.stderr.readline()
                        if line:
                            logger.error('[%s] %s', child.pid, line[:-1])
                        else:
                            p.unregister(child.stderr)

            if not p.fds:
                break

            events = p.poll()

        retcode = child.wait()

        logger.info('[%s] call returned %s', child.pid, retcode)

        if retcode and raise_on_error:
            raise RuntimeError('Subprocess failed with code {}'.format(retcode))

        return retcode
    except gevent.GreenletExit:
        logger.debug('Greenlen has been stopped, killing child process %s', child.pid)
        child.kill()
        raise
