import infra.callisto.libraries.container as container


class Heater(object):
    def ensure_heating(self):
        raise NotImplementedError()

    def ensure_not_heating(self):
        raise NotImplementedError()


class DolbiloHeater(Heater):
    def __init__(
            self,
            host, port,
            dolbilo_path, wood_path,
            argument_url='"&pron=ignore_db_timestamp&pron=nosmfa&allfctrs=da"',
            memory_limit='100M', cpu_limit='1c',
    ):
        self._host = host
        self._port = port
        self._dolbilo_path = dolbilo_path
        self._wood_path = wood_path
        self._memory_limit = memory_limit
        self._cpu_limit = cpu_limit
        self._argument_url = argument_url

    def ensure_heating(self):
        runner = container.ContainerRunner(self._container_name)
        if runner.is_spawned():
            return

        args = [
            self._dolbilo_path,
            '--plan-file', self._wood_path,
            '--queries-limit', '50000',
            '--rps-fixed', '200',
            '--replace-host', self._host,
            '--replace-port', str(self._port),
            '--augmenturl', self._argument_url,
            '--output', '/dev/null',
        ]
        command = ' '.join(args)
        runner.run(
            command=command,
            properties={
                'memory_limit': self._memory_limit,
                'cpu_limit': self._cpu_limit,
            }
        )

    def ensure_not_heating(self):
        runner = container.ContainerRunner(self._container_name)
        runner.stop()

    @property
    def _container_name(self):
        return 'heater-{}'.format(self._port)
