import os
import subprocess


def in_memory_percent(path):
    if not os.path.exists(path):
        raise RuntimeError('{} does not exist'.format(path))

    out = subprocess.check_output(['vmtouch', '-f', path])
    for line in out.splitlines():
        if 'Resident Pages:' in line and line.endswith('%'):
            return float(line.rstrip('%').split()[-1])
