import datetime

from .tables import SortedYtTable


class ObjectStatusTable(SortedYtTable):
    schema = [
        {'name': 'revision', 'type': 'int64', 'sort_order': 'ascending'},
        {'name': 'object_id', 'type': 'string', 'sort_order': 'ascending'},
        {'name': 'update_time', 'type': 'string'},
        {'name': 'status', 'type': 'string'},
    ]

    def _on_init_hook(self):
        self.ensure_table()
        self.ensure_mounted()

    def head(self, object_id):
        request = '* from [{}] where object_id = "{}" order by revision desc limit 1'.format(self._path, object_id)
        for row in self._select_rows(request):
            return row

    # mb update wrt previous revision
    def write(self, object_id, status):
        with self._transaction():
            head = self.head(object_id)
            self._insert_rows([{'object_id': object_id,
                                'status': str(status),
                                'revision': (head and head['revision'] + 1) or 0,
                                'update_time': str(format(datetime.datetime.now()))}],  # timezone?
                              format='yson')
