#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/hamster_commercial_balancer.shutdown.stdout
exec 2>>${LOG_DIR}/hamster_commercial_balancer.shutdown.stderr

echo "$(date) Stop balancer"
retcode=$(/usr/bin/curl -6s -o /dev/null -w '%{http_code}' "http://localhost:$BALANCER_PORT/admin?action=graceful_shutdown&timeout=60s&peek_timeout=4s")
if [ $retcode -eq 200 ] 2>/dev/null; then
    exit 0
fi
echo "Error while balancer stop action"
exit 1
