#!/usr/bin/env sh
set -eux

. /usr/local/runtime/deployer-agent/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

case ${DEPLOY_NODE_DC} in
    man)
        REPORTS_URL=http://man-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://man-configs-cajuper.n.yandex-team.ru
        ;;
    sas)
        REPORTS_URL=http://sas-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://sas-configs-cajuper.n.yandex-team.ru
        ;;
    vla)
        REPORTS_URL=http://vla-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://vla-configs-cajuper.n.yandex-team.ru
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

BSCONFIG_ITAGS="a_itype_deployer ${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}"

SHARDROOT=$(/usr/local/runtime/instancectl_helper/instancectl_helper storage_root)

/agent/agent/agent deployer2 \
    --port ${PORT} \
    --log-dir ${LOG_DIR} \
    --storage-root ${SHARDROOT} \
    --interval 120 \
    --reports-url ${REPORTS_URL} \
    --configs-url ${CONFIGS_URL} \
    --tracker-url=http://vla-tracker-cajuper.n.yandex-team.ru
