#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/hamster_base.start.stdout
exec 2>>${LOG_DIR}/hamster_base.start.stderr

/usr/sbin/portoctl set self cpu_policy idle

SHARDNAME=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_name)

case $GENCFG_TIER in
    ImgTier0)
        CONFIG="imgs.tier0.hamster.cfg"
        ;;
    ImgTier1)
        CONFIG="imgs.tier1.hamster.cfg"
        ;;
    *)
        echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
        exit 1
        ;;
esac

case ${DEPLOY_NODE_DC} in
    man)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=9
                ;;
            ImgTier1)
                CORES=3
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    sas)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=10
                ;;
            ImgTier1)
                CORES=3
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    vla)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=10
                ;;
            ImgTier1)
                CORES=3
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

while ! [ -e "$SHARDNAME" ]; do
    sleep 1
done

ADDITIONAL_PARAMS=""

#if [ -z ${DISABLE_REMOTE_STORAGE+x} ] && [ "${DEPLOY_NODE_DC}" = "sas" ]; then
#ADDITIONAL_PARAMS="-V RemoteSearch=True -V DNSCachePath=/remote_storage/general_dns_cache.proto -V RemoteIndexArcConfigPath=/remote_storage/remote_storage.cfg.proto.hamster"
#fi

/httpsearch/imgsearch2 -p 2080 -d /all/$CONFIG \
    -V MXNetFile=/models.archive/models.archive \
    -V IndexDir="$SHARDNAME" \
    -V ServerLog=${LOG_DIR}/hamster_base.log \
    -V Cores=${CORES} ${ADDITIONAL_PARAMS}
