#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/hamster_cbir.start.stdout
exec 2>>${LOG_DIR}/hamster_cbir.start.stderr

/usr/sbin/portoctl set self cpu_policy idle

SHARDNAME=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_name)

case $GENCFG_TIER in
    ImgTier0)
        CONFIG="imgs.cbir.tier0.hamster.cfg"
        ;;
    ImgTier1)
        CONFIG="imgs.cbir.tier1.hamster.cfg"
        ;;
    *)
        echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
        exit 1
        ;;
esac

case ${DEPLOY_NODE_DC} in
    man)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=2
                ;;
            ImgTier1)
                CORES=1
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    sas)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=2
                ;;
            ImgTier1)
                CORES=1
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    vla)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=2
                ;;
            ImgTier1)
                CORES=1
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

while ! [ -e "$SHARDNAME" ]; do
    sleep 1
done

/httpsearch/imgsearch2 -p 2180 -d /all/$CONFIG \
    -V MXNetFile=/models.archive/models.archive \
    -V IndexDir="$SHARDNAME" \
    -V ServerLog=${LOG_DIR}/hamster_cbir.log \
    -V Cores=${CORES}
