#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/prod_inverted_index.start.stdout
exec 2>>${LOG_DIR}/prod_inverted_index.start.stderr

SHARDNAME=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_name)
DB_TIMESTAMP=$(/usr/local/runtime/instancectl_helper/instancectl_helper db_timestamp)

case ${DEPLOY_NODE_DC} in
    sas | man | vla)
        INDEX_CONFIG="/all/${GENCFG_TIER}.hamster.${DEPLOY_NODE_DC}.index.cfg"
        SERVER_CONFIG="/all/${GENCFG_TIER}.hamster.${DEPLOY_NODE_DC}.server.cfg"
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

/inverted_index_storage/inverted_index_storage \
    --port 2080  \
    --index-dir "$SHARDNAME" \
    --server-config "$SERVER_CONFIG" \
    --inverted-index-config "$INDEX_CONFIG" \
    --db-timestamp "$DB_TIMESTAMP"
