#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/logrotate.check.stdout
exec 2>>${LOG_DIR}/logrotate.check.stderr

if [ -e "/var/run/logrotate.pid" ]; then
    PID="$(cat /var/run/logrotate.pid)"
    if [ -n "${PID}" ]; then
        kill -0 "${PID}"
    else
        echo "pid file /var/run/logrotate.pid empty" > /dev/stderr
        exit 2
    fi
else
    echo "pid file /var/run/logrotate.pid is absent" > /dev/stderr
    exit 1
fi
