#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/prod_base.start.stdout
exec 2>>${LOG_DIR}/prod_base.start.stderr

SHARDNAME=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_name)
SHARD_NUMBER=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_number)
RS_CONFIG="/all/${DEPLOY_NODE_DC}-images-search.tier0-base.${SHARD_NUMBER}.cfg"

case $GENCFG_TIER in
    ImgTier0)
        CONFIG="imgs.tier0.common.cfg"
        ;;
    ImgTier1)
        CONFIG="imgs.tier1.common.cfg"
        ;;
    *)
        echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
        exit 1
        ;;
esac

case ${DEPLOY_NODE_DC} in
    man)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=9
                ;;
            ImgTier1)
                CORES=3
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    sas)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=10
                ;;
            ImgTier1)
                CORES=3
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    vla)
        case $GENCFG_TIER in
            ImgTier0)
                CORES=10
                ;;
            ImgTier1)
                CORES=3
                ;;
            *)
                echo "Unknown tier: '${GENCFG_TIER}'" > /dev/stderr
                exit 1
                ;;
        esac
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

ADDITIONAL_PARAMS=""

if [ -z ${DISABLE_REMOTE_STORAGE+x} ]]; then
    ADDITIONAL_PARAMS="-V RemoteSearch=True -V RemoteIndexArcConfigPath=$RS_CONFIG"

    while ! [ -S /remote_storage_cache.sock ]; do
        sleep 1
    done
fi

/httpsearch/imgsearch2 -p 1080 -d /all/$CONFIG \
    -V MXNetFile=/models.archive/models.archive \
    -V IndexDir="$SHARDNAME" \
    -V ServerLog=${LOG_DIR}/prod_base.log \
    -V Cores=${CORES} ${ADDITIONAL_PARAMS}
