#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

/usr/sbin/portoctl set self cpu_policy idle

SHARDNAME=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_name)

while ! [ -S /remote_storage_cache.sock ]; do
    sleep 1
done

CONFIG=$(dirname ${0})/${GENCFG_TIER}.hamster.${DEPLOY_NODE_DC}.cfg
BASE_RS_CONFIG=$(dirname ${0})/basesearch.rs.${DEPLOY_NODE_DC}.cfg.proto

/httpsearch/videosearch -p ${PORT} -d ${CONFIG} \
    -V LoadLog=/dev/null \
    -V PassageLog=/dev/null \
    -V MXNetFile=/models.archive/videosearch_models.archive \
    -V IndexDir="${SHARDNAME}" \
    -V ServerLog=${LOG_DIR}/server.log \
    -V RemoteSearch=${USE_REMOTE_STORAGE} \
    -V RemoteIndexArcConfigPath=${BASE_RS_CONFIG}
