#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

/usr/sbin/portoctl set self cpu_policy idle

SHARDNAME=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_name)

while ! [ -e "${SHARDNAME}" ]; do
    sleep 1
done

/httpsearch/videosearch -p ${PORT} -d /all/${GENCFG_TIER}.hamster.${DEPLOY_NODE_DC}.cfg \
    -V LoadLog=/dev/null \
    -V PassageLog=/dev/null \
    -V MXNetFile=/models.archive/videosearch_models.archive \
    -V IndexDir="${SHARDNAME}" \
    -V ServerLog=${LOG_DIR}/server.log
