#!/usr/bin/env bash
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/init.stdout
exec 2>>${LOG_DIR}/init.stderr

/usr/local/runtime/instancectl_helper/instancectl_helper link_shard --mode deployer

SHARD_NAME=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_name)

SHARD_ARR=(${SHARD_NAME//-/ })
SHARD_NUMBER=$((10#${SHARD_ARR[1]}))

BASE_RS_CONFIG_TEMPLATE=$(dirname ${0})/template.basesearch.rs.${DEPLOY_NODE_DC}.cfg
BASE_RS_CONFIG=$(dirname ${0})/basesearch.rs.${DEPLOY_NODE_DC}.cfg.proto

cat ${BASE_RS_CONFIG_TEMPLATE} \
    | awk -v shard_number=$SHARD_NUMBER '/Shard: 0/{print "Shard: " shard_number; next;}{print;}' \
    > ${BASE_RS_CONFIG}

