#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARDNAME=$(/usr/local/runtime/instancectl_helper/instancectl_helper shard_name)

case ${DEPLOY_NODE_DC} in
    man)
        CORES=6
        ;;
    sas)
        CORES=7
        ;;
    vla)
        CORES=7
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

/httpsearch/videosearch -p ${PORT} -d /all/${GENCFG_TIER}.prod.${DEPLOY_NODE_DC}.cfg \
    -V LoadLog=/dev/null \
    -V PassageLog=/dev/null \
    -V MXNetFile=/models.archive/videosearch_models.archive \
    -V Cores=${CORES} \
    -V IndexDir="${SHARDNAME}" \
    -V ServerLog=${LOG_DIR}/server.log
