#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

CONTOUR=${CONTOUR:-prod}
SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)
DB_TIMESTAMP=$(${INSTANCECTL_HELPER} db_timestamp)
SHARDNUMBER=$(${INSTANCECTL_HELPER} shard_number)

SERVER_CONFIG=/video/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${CONTOUR}.server.cfg
STORAGE_CONFIG=/video/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${CONTOUR}.storage.cfg
STORAGE_REPLICA_CONFIG=/video/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${SHARDNUMBER}.${CONTOUR}.embeddingstorage.cfg

/embedding_storage/embedding_storage \
    --port ${PORT} \
    --index-dir /${SHARDNAME} \
    --server-config ${SERVER_CONFIG} \
    --embedding-storage-config ${STORAGE_CONFIG} \
    --models-archive /models.archive/models.archive \
    --embedding-storage-replics-config ${STORAGE_REPLICA_CONFIG} \
    --db-timestamp ${DB_TIMESTAMP}
