#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

CONTOUR=${CONTOUR:-prod}
SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)
DB_TIMESTAMP=$(${INSTANCECTL_HELPER} db_timestamp)

INDEX_CONFIG=/video/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${CONTOUR}.index.cfg
SERVER_CONFIG=/video/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${CONTOUR}.server.cfg

/invindex/inverted_index_storage \
    --port ${PORT} \
    --index-dir /${SHARDNAME} \
    --server-config ${SERVER_CONFIG} \
    --inverted-index-config ${INDEX_CONFIG} \
    --db-timestamp ${DB_TIMESTAMP}
