#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARD_NUMBER=$(${INSTANCECTL_HELPER} shard_number)
CONFIG=/web/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${SHARD_NUMBER}.cfg

case "${GENCFG_TIER}" in
    PlatinumTier0)
        ;;
    WebTier0)
        ADDITIONAL_PARAMETERS="${ADDITIONAL_PARAMETERS} \
                               -V EventLogQueueSize=1024 \
                               -V MXNetFile=/models.archive/models.archive"
        ;;
    WebTier1)
        ADDITIONAL_PARAMETERS="${ADDITIONAL_PARAMETERS} \
                               -V EventLogQueueSize=1024 \
                               -V MXNetFile=/models.archive/models.archive"
        ;;
    *)
        echo "Unknown GENCFG_TIER (${GENCFG_TIER})" > /dev/stderr
        exit 1
        ;;
esac

/usr/local/webruntime/common/run-debuggable.sh prod \
    /l1_intsearch/l1_intsearch -p ${PORT} -d ${CONFIG} \
    -V "LoadLog=/dev/null" \
    -V "EventLog=${LOG_DIR}/eventlog" \
    -V "SdLog=${LOG_DIR}/sd.log" \
    -V "ServerLog=${LOG_DIR}/server.log" \
    -V "ReAskOptions=${REASK_OPTIONS}" \
    -V "TimeoutTable=${TIME_TABLE}" \
    -V "RequestThreads=30" \
    -V "ServerThreads=20" \
    -V "ProfileStatsSignals=yes" \
    -V "ProfileStatsReport=yes" \
    ${ADDITIONAL_PARAMETERS}
