#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

if [ -z "${GENCFG_TIER}" ]; then
    echo "Tier not found" > /dev/stderr
    exit 1
fi

/usr/local/webruntime/script/eventlog_uploader \
    --yt-proxy hahn.yt.yandex.net \
    --yt-token-env YT_TOKEN \
    --evlogfolder //home/eventlogdata/${GENCFG_TIER} \
    --evlogdump /evlogdump/evlogdump \
    --instance ${DEPLOY_POD_ID} \
    --log ${LOG_DIR}/../prod/eventlog \
    --enable-utf8 \
    --period 90 \
    --sleep 1800 \
    --chance 0.004 \
    --days 3
