#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARD_NUMBER=$(${INSTANCECTL_HELPER} shard_number)
CONFIG=/web/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${SHARD_NUMBER}.cfg

/usr/local/webruntime/common/run-debuggable.sh prod \
    /intsearch/intsearch -p ${PORT} -d ${CONFIG} \
    -V "LoadLog=/dev/null" \
    -V "EventLog=${LOG_DIR}/eventlog" \
    -V "SdLog=${LOG_DIR}/sd.log" \
    -V "ServerLog=${LOG_DIR}/server.log" \
    -V "CommonSourceOptions=EnableIpV6=yes,EnableUnresolvedHosts=yes,Searcher=http2:+0,AllowBalancerDynamic=1" \
    -V "CompressionString=Compression true" \
    -V "ReAskOptions=${REASK_OPTIONS}" \
    -V "TimeoutTable=${TIME_TABLE}" \
    -V "SpawnOptions=DelayAddition=5ms,OnlySearch=true,CheckQuantile=0.5,MaxFreq=0.1"
