#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)
DB_TIMESTAMP=$(${INSTANCECTL_HELPER} db_timestamp)

INDEX_CONFIG=/web/${GENCFG_TIER}.${CONTOUR}.${DEPLOY_NODE_DC}.index.cfg
SERVER_CONFIG=/web/${GENCFG_TIER}.${CONTOUR}.${DEPLOY_NODE_DC}.server.cfg

/usr/local/webruntime/common/run-debuggable.sh debug-prod \
    /invindex/inverted_index_storage \
    --port ${PORT} \
    --index-dir /${SHARDNAME} \
    --server-config ${SERVER_CONFIG} \
    --inverted-index-config ${INDEX_CONFIG} \
    --db-timestamp ${DB_TIMESTAMP}
