#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)

SERVER_CONFIG=/web/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${CONTOUR}.server.cfg
KEYINV_CONFIG=/web/${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}.${CONTOUR}.keyinv.cfg

/usr/local/webruntime/common/run-debuggable.sh debug-prod \
    /keyinv/keyinv \
    --port ${PORT} \
    --server-config ${SERVER_CONFIG} \
    --keyinv-config ${KEYINV_CONFIG} \
    --index-dir /${SHARDNAME}
