#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

while ! $(/bin/nc -z localhost 80); do
    sleep 3
done

case ${DEPLOY_NODE_DC} in
    man)
        REPORTS_URL=http://man-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://man-configs-cajuper.n.yandex-team.ru
        ;;
    sas)
        REPORTS_URL=http://sas-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://sas-configs-cajuper.n.yandex-team.ru
        ;;
    vla)
        REPORTS_URL=http://vla-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://vla-configs-cajuper.n.yandex-team.ru
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

export BSCONFIG_ITAGS="a_itype_base ${DEPLOY_STAGE_ID}.${DEPLOY_UNIT_ID}"

SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)
STORAGE_ROOT=$(${INSTANCECTL_HELPER} storage_root)

/agent/agent/agent multibeta2 \
    --port ${PORT} \
    --log-dir ${LOG_DIR} \
    --interval 120 \
    --reports-url ${REPORTS_URL} \
    --configs-url ${CONFIGS_URL} \
    --storage-root ${STORAGE_ROOT} \
    --shard ${SHARDNAME} \
    --balancer-bin /balancer_bin/balancer \
    --balancer-cfg /balancer_cfg/balancer.cfg
