#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)
TIERNAME=$(${INSTANCECTL_HELPER} tier_name)
CONFIG=${CONFIG:-"/web/${TIERNAME}.${CONTOUR}.${DEPLOY_NODE_DC}.cfg"}

/usr/local/webruntime/common/run-debuggable.sh debug-${CONTOUR} \
    /httpsearch/basesearch -p ${PORT} -d ${CONFIG} \
    -V LoadLog=/dev/null \
    -V PassageLog=/dev/null \
    -V AbnormalityLog=/dev/null \
    -V MXNetFile=/models.archive/models.archive \
    -V IndexDir="${SHARDNAME}" \
    -V ServerLog=${LOG_DIR}/server.log \
    ${CUSTOM_ARGS:-}
