#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/check.stdout
exec 2>>${LOG_DIR}/check.stderr

if [ -e "${PID_FILE}" ]; then
    PID="$(cat ${PID_FILE})"
    if [ -n "${PID}" ]; then
        kill -0 "${PID}"
    else
        echo "pid file ${PID_FILE} empty" > /dev/stderr
        exit 2
    fi
else
    echo "pid file ${PID_FILE} is absent" > /dev/stderr
    exit 1
fi
