#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

while ! $(/bin/nc -z localhost 80); do
    sleep 3
done

case ${DEPLOY_NODE_DC} in
    man)
        REPORTS_URL=http://man-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://man-configs-cajuper.n.yandex-team.ru
        ;;
    sas)
        REPORTS_URL=http://sas-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://sas-configs-cajuper.n.yandex-team.ru
        ;;
    vla)
        REPORTS_URL=http://vla-reports-v2-cajuper.n.yandex-team.ru
        CONFIGS_URL=http://vla-configs-cajuper.n.yandex-team.ru
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)
STORAGE_ROOT=$(${INSTANCECTL_HELPER} storage_root)

# old (pre-chunk-ctrl) RS settings
RS_CONFIG_NAME=/remote_storage_configs/${DEPLOY_NODE_DC}/${SHARDNAME}.proto.hamster
DNS_CACHE_PATH=/remote_storage_configs/${DEPLOY_NODE_DC}/general_dns_cache.proto

# new RS settings
if [ ${DEPLOY_NODE_DC} = "sas" ] || [ ${DEPLOY_NODE_DC} = "vla" ]; then
    SHARD_NUMBER=$(${INSTANCECTL_HELPER} shard_number)
    RS_CONFIG_NAME=/web/${DEPLOY_NODE_DC}-web-search.tier0-base.${SHARD_NUMBER}.hamster.cfg
    DNS_CACHE_PATH=""
fi

USE_MULTI_LEVEL_CACHE_MAPPING=false
MULTI_LEVEL_CACHE_MAPPING_SUFFIX="replicas"

/agent/agent/agent multibeta2 \
    --port ${PORT} \
    --log-dir ${LOG_DIR} \
    --interval 120 \
    --reports-url ${REPORTS_URL} \
    --configs-url ${CONFIGS_URL} \
    --storage-root ${STORAGE_ROOT} \
    --shard ${SHARDNAME} \
    --balancer-bin /balancer_bin/balancer \
    --balancer-cfg /balancer_cfg/balancer.cfg \
    --extra-arguments "-V UseMultiLevelCacheIndexMapping=${USE_MULTI_LEVEL_CACHE_MAPPING} \
                       -V MultiLevelCacheIndexMappingSuffix=${MULTI_LEVEL_CACHE_MAPPING_SUFFIX} \
                       -V RemoteIndexArcConfigPath=${RS_CONFIG_NAME} \
                       -V DNSCachePath=${DNS_CACHE_PATH} \
                       -V SelfFqdn=${DEPLOY_POD_PERSISTENT_FQDN}"
