#!/usr/bin/env sh

CONTOUR=prod
INSTANCECTL_HELPER=/usr/local/webruntime/instancectl_helper/instancectl_helper
LOG_DIR=/var/log/webruntime/${CONTOUR}
PORT=80

SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)
SHARD_NUMBER=$(${INSTANCECTL_HELPER} shard_number)
RS_CONFIG_NAME=/remote_storage_configs/${DEPLOY_NODE_DC}/${SHARDNAME}.proto
DNS_CACHE_PATH=/remote_storage_configs/${DEPLOY_NODE_DC}/general_dns_cache.proto
REMOTE_ATTRS_CONFIG_PATH=
if [ ${DEPLOY_NODE_DC} = "sas" ] || [ ${DEPLOY_NODE_DC} = "vla" ]; then
    RS_CONFIG_NAME=/web/${DEPLOY_NODE_DC}-web-search.tier0-base.${SHARD_NUMBER}.cfg
    DNS_CACHE_PATH=""
fi
if [ ${DEPLOY_NODE_DC} = "sas" ]; then
    REMOTE_ATTRS_CONFIG_PATH=/web/${DEPLOY_NODE_DC}-web-search.tier0-base.remote-attrs.${SHARD_NUMBER}.${CONTOUR}.cfg
fi

ARC_LRU_CACHE_ENABLED=true
LOAD_LOG=/dev/null
EVENTLOG_ENABLE_HOOK_PATH=/controls/eventlog-log-enable

SDCACHE=sd_cache

mkdir -p ${LOG_DIR}
