#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/init.stdout
exec 2>>${LOG_DIR}/init.stderr

${INSTANCECTL_HELPER} set_topology_dir --target topology_cache --storage topologies/prod --rotate-limit 10

${INSTANCECTL_HELPER} link_shard --mode deployer

INDEXES_TO_TOUCH='(mapping\.\d+\.wad|indexsortedinvhash\.wad|index\.replicas\.mapping\.wad|indexherf\.wad)$'
find -L ${SHARDNAME} -maxdepth 1 -type f | grep -P $INDEXES_TO_TOUCH | xargs vmtouch -t
