#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

while ! [ -S /remote_storage_cache.sock ]; do
    sleep 1
done

CONFIG=/web/${GENCFG_TIER}.${CONTOUR}.${DEPLOY_NODE_DC}.cfg
USE_MULTI_LEVEL_CACHE_MAPPING=false
MULTI_LEVEL_CACHE_MAPPING_SUFFIX=replicas

/usr/local/webruntime/common/run-debuggable.sh debug-prod \
    /httpsearch/basesearch -p ${PORT} -d ${CONFIG} \
    -V "AbnormalityLog=/dev/null" \
    -V "DNSCachePath=${DNS_CACHE_PATH}" \
    -V "EventLog=${LOG_DIR}/eventlog" \
    -V "IndexDir=${SHARDNAME}" \
    -V "LoadLog=${LOAD_LOG}" \
    -V "MXNetFile=/models.archive/models.archive" \
    -V "PassageLog=/dev/null" \
    -V "RemoteIndexArcConfigPath=${RS_CONFIG_NAME}" \
    -V "RemoteIndexAttrsConfigPath=${REMOTE_ATTRS_CONFIG_PATH}" \
    -V "SelfFqdn=${DEPLOY_POD_PERSISTENT_FQDN}" \
    -V "ServerLog=${LOG_DIR}/server.log" \
    -V "UseMultiLevelCacheIndexMapping=${USE_MULTI_LEVEL_CACHE_MAPPING}" \
    -V "ArcLruCacheEnabled=${ARC_LRU_CACHE_ENABLED}" \
    -V "RemoteSearch=true" \
    -V "MultiLevelCacheIndexMappingSuffix=${MULTI_LEVEL_CACHE_MAPPING_SUFFIX}" \
    -V "EventLogEnableHookPath=${EVENTLOG_ENABLE_HOOK_PATH}" \
    -V "SdCacheDir=$SDCACHE"
