#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARDNAME=$(${INSTANCECTL_HELPER} shard_name)

/remote_storage/remote_storage --port ${PORT} \
    --base-path ${SHARDNAME}/multi_level_cache/cache \
    --index-config /remote_storage_cache_index.proto \
    --server-config /remote_storage_cache_server.cfg \
    --maxevents ${MAXEVENTS} \
    --iteration-rate 5 \
    --poll-interval 1s \
    --listener-backlog 128 \
    --max-active-conns 80000 \
    --inactive-timeout 0.5s \
    --unix-socket ${UNIX_SOCKET} \
    --queue-size 150
