#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

while ! $(/bin/nc -z localhost 80); do
    sleep 3
done

SHARDNAME=$(/usr/local/webruntime/instancectl_helper/instancectl_helper shard_name)
RS_CONFIG_NAME=$(/usr/local/webruntime/instancectl_helper/instancectl_helper rs_config_name)

while ! [ -S /hamster_remote_storage_cache.sock ]; do
    sleep 1
done

CONFIG=/web/${GENCFG_TIER}.hamster.${DEPLOY_NODE_DC}.cfg

/usr/local/webruntime/common/run-debuggable.sh debug-hamster \
    /httpsearch/basesearch -p ${PORT} -d ${CONFIG} \
    -V AbnormalityLog=/dev/null \
    -V DNSCachePath=/remote_storage_configs/${DEPLOY_NODE_DC}/general_dns_cache.proto \
    -V EnableArcLumpFetcher=true \
    -V EventLog=${LOG_DIR}/eventlog.log \
    -V IndexDir=${SHARDNAME} \
    -V LoadLog=/dev/null \
    -V MXNetFile=/models.archive/models.archive \
    -V PassageLog=/dev/null \
    -V RemoteIndexArcConfigPath=/remote_storage_configs/${DEPLOY_NODE_DC}/${RS_CONFIG_NAME}.hamster \
    -V SelfFqdn=${DEPLOY_POD_PERSISTENT_FQDN} \
    -V ServerLog=${LOG_DIR}/server.log \
    -V UseMultiLevelCacheIndexMapping=true \
    -V RemoteSearch=true
