#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARDNAME=$(/usr/local/webruntime/instancectl_helper/instancectl_helper shard_name)
RS_CONFIG_NAME=$(/usr/local/webruntime/instancectl_helper/instancectl_helper rs_config_name)

while ! [ -S /remote_storage_cache.sock ]; do
    sleep 1
done

USE_MULTI_LEVEL_CACHE_MAPPING=True
MULTI_LEVEL_CACHE_MAPPING_SUFFIX=""

CONFIG=/web/${GENCFG_TIER}.prod.${DEPLOY_NODE_DC}.cfg

case ${DEPLOY_NODE_DC} in
    man)
        CORES=17
        ;;
    sas)
        CORES=19
        ;;
    vla)
        CORES=19
        USE_MULTI_LEVEL_CACHE_MAPPING=False
        MULTI_LEVEL_CACHE_MAPPING_SUFFIX="replicas"
        ;;
    *)
        echo "Unknown DEPLOY_NODE_DC (${DEPLOY_NODE_DC})" > /dev/stderr
        exit 1
        ;;
esac

/usr/local/webruntime/common/run-debuggable.sh debug-prod \
    /httpsearch/basesearch -p ${PORT} -d ${CONFIG} \
    -V AbnormalityLog=/dev/null \
    -V Cores=${CORES} \
    -V DNSCachePath=/remote_storage_configs/${DEPLOY_NODE_DC}/general_dns_cache.proto \
    -V EventLog=${LOG_DIR}/eventlog.log \
    -V IndexDir=${SHARDNAME} \
    -V LoadLog=/dev/null \
    -V MXNetFile=/models.archive/models.archive \
    -V PassageLog=/dev/null \
    -V RemoteIndexArcConfigPath=/remote_storage_configs/${DEPLOY_NODE_DC}/${RS_CONFIG_NAME} \
    -V SelfFqdn=${DEPLOY_POD_PERSISTENT_FQDN} \
    -V ServerLog=${LOG_DIR}/server.log \
    -V UseMultiLevelCacheIndexMapping=$USE_MULTI_LEVEL_CACHE_MAPPING \
    -V ArcLruCacheEnabled=true \
    -V RemoteSearch=True \
    -V MultiLevelCacheIndexMappingSuffix=$MULTI_LEVEL_CACHE_MAPPING_SUFFIX
