#!/usr/bin/env sh
set -eux

. $(dirname ${0})/common.sh

exec 1>>${LOG_DIR}/start.stdout
exec 2>>${LOG_DIR}/start.stderr

SHARDNAME=$(/usr/local/webruntime/instancectl_helper/instancectl_helper shard_name)

/remote_storage/remote_storage --port ${PORT} \
    --base-path ${SHARDNAME}/multi_level_cache/cache \
    --index-config /remote_storage_cache_index.proto \
    --server-config /remote_storage_cache_server.cfg \
    --maxevents 32 \
    --iteration-rate 5 \
    --poll-interval 1s \
    --listener-backlog 128 \
    --max-active-conns 80000 \
    --inactive-timeout 0.5s \
    --unix-socket /remote_storage_cache.sock \
    --queue-size 300
