import datetime

import infra.callisto.reports.report as report_module


class ReportsConsumer(object):
    def __init__(self):
        super(ReportsConsumer, self).__init__()
        self._reports = {}
        self._first_report = None

    @property
    def uptime(self):
        now = datetime.datetime.now()
        return (now - (self._first_report or now)).total_seconds()

    def consume_reports(self, reports):
        for report in reports:
            agent = (report.host, report.port)
            if (
                agent not in self._reports
                or self._reports[agent].generation_time < report.generation_time
            ):
                self._reports[agent] = report
        self._first_report = self._first_report or datetime.datetime.now()

    def with_tags(self, tags):
        return report_module.reports_with_tags(self._reports.values(), tags)

    def get(self, host, port):
        result = self._reports.get((host, port), None)
        return result
