import os
import argparse

import infra.callisto.libraries.logging as cajuper_logging

import app as reports_app


def ensure_dir(path):
    if not os.path.exists(path):
        os.makedirs(path)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--port', help='Server port', type=int)
    parser.add_argument('--debug', help='Debug mode (dump logs to stdout)', action='store_true', default=False)
    return parser.parse_args()


def main():
    args = parse_args()
    cajuper_logging.configure_logging(path_to_logs='./logs', debug=args.debug)

    app = reports_app.create_app()

    from gevent.pywsgi import WSGIServer
    WSGIServer(('::', args.port), app).serve_forever()
