#pragma once

#include "storage.h"
#include "context.h"

#include <infra/bubble/handler.h>
#include <library/cpp/cgiparam/cgiparam.h>
#include <util/string/split.h>


namespace NReportsKeeper::NHandlers {
    class THandler : public NBubbleServer::THandler {
    public:
        THandler() = delete;
        explicit THandler(TAtomicSharedPtr<TContext>& context)
            : Context_(context)
        {
        }

        virtual TStorage& Storage() {
            return Context_->Storage();
        }

    private:
        TAtomicSharedPtr<TContext> Context_;
    };

    class TWithTags : public THandler {
    public:
        using THandler::THandler;
        bool MatchRequest(const NBubbleServer::TRequest& request) const override {
            return request.Method == "GET" && request.Path.StartsWith("/with_tags");
        }
        THttpResponse Execute(const NBubbleServer::TRequest& request) override;
    };

    class TGetReport : public THandler {
    public:
        using THandler::THandler;
        bool MatchRequest(const NBubbleServer::TRequest& request) const override {
            return request.Method == "GET" && request.Path.StartsWith("/report/");
        }
        THttpResponse Execute(const NBubbleServer::TRequest& request) override;
    };

    class TConsumeReport : public THandler {
    public:
        using THandler::THandler;
        bool MatchRequest(const NBubbleServer::TRequest& request) const override {
            return request.Method == "POST" && request.Path == "/report";
        }
        THttpResponse Execute(const NBubbleServer::TRequest& request) override;
    };
}
