#pragma once

#include <infra/callisto/reports/proto/report.pb.h>
#include <util/generic/vector.h>
#include <util/generic/set.h>
#include <util/generic/hash.h>
#include <util/system/rwlock.h>
#include <util/datetime/base.h>

namespace NReportsKeeper {
    class TReport;
    using TInstance = std::pair<TString, ui32>;
    using TReportRef = TAtomicSharedPtr<TReport>;

    class TReport: public infra::callisto::TReportMessage {
    public:
        explicit TReport(const infra::callisto::TReportMessage& reportMessage)
            : infra::callisto::TReportMessage(reportMessage)
            , Instance_({Gethost(), Getport()})
            , Tags_({Gettags().begin(), Gettags().end()})
        {
        }
        const TInstance& Instance() const;
        const TSet<TString>& Tags() const;
        bool MatchTags(const TSet<TString>& tags) const;
        TString DumpHumanReadable() const;

    private:
        TInstance Instance_;
        TSet<TString> Tags_;
    };

    class TStorage {
    public:
        TStorage()
            : Dict_()
            , Mutex_()
            , FirstReportConsumed_(TInstant::Zero())
        {
        }
        TVector<TReportRef> WithTags(const TSet<TString>& tags);
        TReportRef GetReport(const TInstance&);
        void ConsumeReport(TReportRef report);
        TDuration SinceFirstReport() const;

    private:
        THashMap<TInstance, TReportRef> Dict_;
        TRWMutex Mutex_;
        TInstant FirstReportConsumed_;
    };

}
