import gevent.monkey
gevent.monkey.patch_all()  # noqa

import argparse
import logging
import socket
import gevent.pywsgi as gwsgi
import library.python.svn_version as svn_version

import infra.callisto.libraries.logging as cajuper_logging
import infra.callisto.controllers.core.conveyor as conveyor
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.utils.gencfg_api as gencfg_api


def main():
    registry.init_users()
    args = parse_args()

    cajuper_logging.configure_logging(path_to_logs=args.logs_dir, debug=args.debug)
    logging.getLogger('urllib3.connectionpool').setLevel(logging.INFO)
    logging.getLogger('yt.packages.urllib3.connectionpool').setLevel(logging.CRITICAL)

    if args.gencfg_cache:
        gencfg_api.use_local_cache()

    loop, app = conveyor.create_app(args.ctrl, args.readonly, socket.getfqdn(), args.port, args.enable_lock,
                                    args.ctrl_config)
    gevent.spawn(_run_http_server, app, args.port)
    if args.profile:
        import profile
        with profile.profile(30):
            loop()
    else:
        loop()


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--version', action='version', version=str(svn_version.svn_revision()))
    parser.add_argument('--port', help='Server port', default=8080, type=int)
    parser.add_argument('--debug', help='Debug mode (dump logs to stdout)', action='store_true', default=False)
    parser.add_argument('--profile', help='Run ctrl loop under profiler', action='store_true', default=False)
    parser.add_argument('--logs-dir', help='Path to store logs', default='./logs')
    parser.add_argument('--readonly', help='Readonly mode', default=True, action='store_true')
    parser.add_argument('--not-readonly', help='Not readonly mode', action='store_false', dest='readonly')
    parser.add_argument('--enable-lock', action='store_true', default=False)
    parser.add_argument('--disable-lock', action='store_false', dest='enable_lock')
    parser.add_argument('--ctrl', help='Root ctrl to serve', choices=sorted(registry.ROOT_CTRLS), required=True)
    parser.add_argument('--gencfg-cache', help='Use local gencfg cache; speeds up local restarts', action='store_true')
    parser.add_argument('--ctrl-config', help='Config file for root ctrl')

    return parser.parse_args()


def _run_http_server(app, port):
    gwsgi.WSGIServer(('::', port), app).serve_forever()
